// linkStack.java
// demonstruje stos zaimplementowany przy uyciu listy powizanej
// uruchominie programu: C>java LinkStackApp
////////////////////////////////////////////////////////////////
class Link
   {
   public long dData;             // dane
   public Link next;              // nastpny element listy
// -------------------------------------------------------------
   public Link(long dd)           // konstruktor
      { dData = dd; }
// -------------------------------------------------------------
   public void displayLink()      // wypisanie klucza elementu
      { System.out.print(dData + " "); }
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class LinkList
   {
   private Link first;            // referencja do pierwszego elementu
// -------------------------------------------------------------
   public LinkList()              // konstruktor
      { first = null; }           // na razie brak elementw
// -------------------------------------------------------------
   public boolean isEmpty()       // zwraca true, jeeli lista jest pusta
      { return (first==null); }
// -------------------------------------------------------------
   public void insertFirst(long dd) // wstawienie na pocztek listy
      {                           // tworzymy nowy element
      Link newLink = new Link(dd);
      newLink.next = first;       // newLink --> poprzedni pierwszy
      first = newLink;            // first --> newLink
      }
// -------------------------------------------------------------
   public long deleteFirst()      // usunicie pierwszego elementu
      {                           // (zakadamy, e lista nie jest pusta)
      Link temp = first;          // zapisujemy referencj do usuwanego elementu
      first = first.next;         // usunicie: first-->poprzedni drugi
      return temp.dData;          // zwracamy usunity element
      }
// -------------------------------------------------------------
   public void displayList()
      {
      Link current = first;       // rozpoczynamy na pocztku listy
      while(current != null)      // dopki nie koniec...
         {
         current.displayLink();   // ...wypisujemy dane...
         current = current.next;  // ...i przechodzimy do nastpnego
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // koniec klasy LinkList
////////////////////////////////////////////////////////////////
class LinkStack
   {
   private LinkList theList;
//--------------------------------------------------------------
   public LinkStack()             // konstruktor
      {
      theList = new LinkList();
      }
//--------------------------------------------------------------
   public void push(long j)     // odoenie elementu na szczyt stosu
      {
      theList.insertFirst(j);
      }
//--------------------------------------------------------------
   public long pop()            // zdjcie elementu ze szczytu stosu
      {
      return theList.deleteFirst();
      }
//--------------------------------------------------------------
   public boolean isEmpty()       // zwraca true, jeeli stos pusty
      {
      return ( theList.isEmpty() );
      }
//--------------------------------------------------------------
   public void displayStack()
      {
      System.out.print("Stos (szczyt-->dno): ");
      theList.displayList();
      }
//--------------------------------------------------------------
   }  // koniec klasy LinkStack
////////////////////////////////////////////////////////////////
class LinkStackApp
   {
   public static void main(String[] args)
      {
      LinkStack theStack = new LinkStack(); // tworzymy stos

      theStack.push(20);                    // odkadamy elementy
      theStack.push(40);

      theStack.displayStack();              // wypisujemy zawarto stosu

      theStack.push(60);                    // odkadamy elementy
      theStack.push(80);

      theStack.displayStack();              // wypisujemy zawarto stosu

      theStack.pop();                       // zdejmujemy elementy
      theStack.pop();

      theStack.displayStack();              // wypisujemy zawarto stosu
      }  // koniec main()
   }  // koniec klasy LinkStackApp
////////////////////////////////////////////////////////////////
